import requests

class EditoraAPI:
    def __init__(self, base_url, jwt_token, add_endpoint, msg_q=None):
        self.base = base_url.rstrip("/")
        self.token = jwt_token.strip()
        self.add_endpoint = add_endpoint
        self.msg_q = msg_q

    def add_product(self, title, cover, preview, download_link, envato_url):
        payload = {
            "title": title,
            "cover": cover or "",
            "preview": preview or "",
            "download_link": download_link,
            "editora_envato": envato_url
        }
        r = requests.post(f"{self.base}{self.add_endpoint}", headers={
            "Authorization": f"Bearer {self.token}", "Content-Type":"application/json"
        }, json=payload, timeout=30)
        if r.status_code >= 400:
            raise Exception(f"API add-product failed: {r.status_code} {r.text}")
        return r.json().get("id")
