from ftplib import FTP
from pathlib import Path
import os

class FtpClient:
    def __init__(self, host, user, password, msg_q=None):
        self.host=host; self.user=user; self.password=password; self.msg_q=msg_q

    def _log(self, m):
        if self.msg_q: self.msg_q.put(m)

    def _connect(self):
        ftp = FTP(self.host, timeout=60); ftp.login(self.user, self.password); return ftp

    def _ensure(self, ftp, d):
        parts=[p for p in d.strip("/").split("/") if p]; cur=""
        for part in parts:
            cur=f"{cur}/{part}"
            try: ftp.cwd(cur)
            except: ftp.mkd(cur)

    def _unique(self, ftp, dir_path, filename):
        base, ext = os.path.splitext(filename); name=filename; idx=1
        def exists(n):
            try: ftp.size(f"{dir_path}/{n}"); return True
            except: return False
        while exists(name):
            name=f"{base} ({idx}){ext}"; idx+=1
        return name

    def _upload(self, ftp, local_path, remote_dir, remote_name):
        self._ensure(ftp, remote_dir)
        name = self._unique(ftp, remote_dir, remote_name)
        with open(local_path, "rb") as f:
            ftp.storbinary(f"STOR {remote_dir}/{name}", f)
        return f"{remote_dir}/{name}"

    def upload_all(self, year, month, basename, local_img=None, local_mp4=None, local_zip=None):
        remote={}
        with self._connect() as ftp:
            if local_zip and Path(local_zip).exists():
                remote["ZIP_PATH"]=self._upload(ftp, local_zip, f"/www/downloads/vip/{year}/{month}", f"{basename}.zip")
                self._log(f"↑ ZIP: {remote['ZIP_PATH']}")
            if local_img and Path(local_img).exists():
                remote["IMG_PATH"]=self._upload(ftp, local_img, f"/www/image/vip/{year}/{month}", f"{basename}.jpg")
                self._log(f"↑ IMG: {remote['IMG_PATH']}")
            if local_mp4 and Path(local_mp4).exists():
                remote["VIDEO_PATH"]=self._upload(ftp, local_mp4, f"/www/video/vip/{year}/{month}", f"{basename}.mp4")
                self._log(f"↑ VIDEO: {remote['VIDEO_PATH']}")
        return remote

    def to_cdn(self, remote):
        out={}
        if "ZIP_PATH" in remote: out["ZIP_URL"]=remote["ZIP_PATH"].replace("/www","https://s1.editora.ir")
        if "IMG_PATH" in remote: out["IMG_URL"]=remote["IMG_PATH"].replace("/www","https://s1.editora.ir")
        if "VIDEO_PATH" in remote: out["VIDEO_URL"]=remote["VIDEO_PATH"].replace("/www","https://s1.editora.ir")
        return out
