import os
import requests
from ftplib import FTP
from playwright.sync_api import sync_playwright

# تنظیمات FTP
FTP_HOST = "dl9.hostdl.com"
FTP_USER = "dls1edito"
FTP_PASS = "dp1mS4vWUUd0HcN0s"

BASE_DOWNLOAD_DIR = "downloads"
YEAR = "1404"
MONTH = "5"  # قابل تغییر دستی

def ftp_upload(file_path, remote_path):
    try:
        with FTP(FTP_HOST) as ftp:
            ftp.login(FTP_USER, FTP_PASS)

            # حرکت در مسیر
            parts = remote_path.strip("/").split("/")
            for part in parts[:-1]:
                try:
                    ftp.cwd(part)
                except:
                    ftp.mkd(part)
                    ftp.cwd(part)

            with open(file_path, "rb") as f:
                ftp.storbinary(f"STOR " + parts[-1], f)
            print(f"✅ آپلود شد: {remote_path}")
    except Exception as e:
        print(f"❌ خطا در آپلود {file_path} → {e}")

def read_links_from_file():
    with open("links.txt", "r", encoding="utf-8") as f:
        return [line.strip() for line in f if line.strip()]

def sanitize_filename(name):
    return "".join(c for c in name if c.isalnum() or c in (' ', '-', '_')).rstrip()

def download_file(url, filepath):
    try:
        response = requests.get(url)
        if response.status_code == 200:
            with open(filepath, "wb") as f:
                f.write(response.content)
            print(f"✅ دانلود شد: {filepath}")
        else:
            print(f"❌ خطا در دانلود {url}")
    except Exception as e:
        print(f"❌ خطا در اتصال به {url} → {e}")

def write_link_to_txt(folder_path, folder_name, link):
    file_path = os.path.join(folder_path, f"{folder_name}.txt")
    with open(file_path, "w", encoding="utf-8") as f:
        f.write(link)

def scrape_envato_assets():
    links = read_links_from_file()

    with sync_playwright() as p:
        context = p.chromium.launch_persistent_context(
            user_data_dir="envato_profile",
            headless=False
        )
        page = context.new_page()

        for link in links:
            try:
                page.goto(link)
                page.wait_for_load_state("networkidle")

                # عنوان محصول
                title = page.locator("h1").inner_text().strip()
                folder_name = sanitize_filename(title)
                full_folder_path = os.path.join(BASE_DOWNLOAD_DIR, folder_name)
                os.makedirs(full_folder_path, exist_ok=True)

                write_link_to_txt(full_folder_path, folder_name, link)

                # تصویر شاخص
                try:
                    image_url = page.locator("meta[property='og:image']").get_attribute("content")
                    if image_url:
                        image_path = os.path.join(full_folder_path, f"{folder_name}.jpg")
                        download_file(image_url, image_path)
                        ftp_upload(image_path, f"/www/image/{YEAR}/{MONTH}/{folder_name}.jpg")
                except:
                    print("❌ تصویر شاخص یافت نشد")

                # ویدیوی دمو
                try:
                    preview_url = page.locator("[data-testid='button-download-preview']").get_attribute("href")
                    if preview_url:
                        video_path = os.path.join(full_folder_path, f"{folder_name}.mp4")
                        download_file(preview_url, video_path)
                        ftp_upload(video_path, f"/www/video/{YEAR}/{MONTH}/{folder_name}.mp4")
                except:
                    print("❌ لینک ویدیوی دمو یافت نشد")

                # فایل ZIP
                try:
                    page.click("button:has-text('Download')")
                    page.wait_for_selector("button[data-testid='download-without-license-button']", timeout=5000)
                    with page.expect_download() as download_info:
                        page.click("button[data-testid='download-without-license-button']")
                    download = download_info.value
                    zip_path = os.path.join(full_folder_path, f"{folder_name}.zip")
                    download.save_as(zip_path)
                    print(f"✅ فایل اصلی ذخیره شد: {zip_path}")
                    ftp_upload(zip_path, f"/www/downloads/vip/{YEAR}/{MONTH}/{folder_name}.zip")
                except Exception as e:
                    print(f"❌ خطا در دانلود فایل اصلی: {e}")

            except Exception as e:
                print(f"❌ خطا در پردازش لینک: {link} → {e}")

        context.close()

if __name__ == "__main__":
    scrape_envato_assets()
