import os
import requests
from ftplib import FTP
from tkinter import *
from tkinter.ttk import Progressbar
from playwright.sync_api import sync_playwright
import threading
from upload_to_wordpress import upload_to_wordpress

# FTP تنظیمات
FTP_HOST = "dl9.hostdl.com"
FTP_USER = "dls1edito"
FTP_PASS = "dp1mS4vWUUd0HcN0s"
BASE_DOWNLOAD_DIR = "downloads"
YEAR = "1404"

uploaded_products = []

def ftp_upload(file_path, remote_path, log_widget):
    try:
        with FTP(FTP_HOST) as ftp:
            ftp.login(FTP_USER, FTP_PASS)
            parts = remote_path.strip("/").split("/")
            for part in parts[:-1]:
                try:
                    ftp.cwd(part)
                except:
                    ftp.mkd(part)
                    ftp.cwd(part)
            with open(file_path, "rb") as f:
                ftp.storbinary("STOR " + parts[-1], f)
        log_widget.insert(END, f"✅ آپلود شد: {remote_path}\n")
        log_widget.see(END)
    except Exception as e:
        log_widget.insert(END, f"❌ خطا در آپلود {file_path} → {e}\n")
        log_widget.see(END)

def read_links_from_file():
    with open("links.txt", "r", encoding="utf-8") as f:
        return [line.strip() for line in f if line.strip()]

def sanitize_filename(name):
    return "".join(c for c in name if c.isalnum() or c in (' ', '-', '_')).rstrip()

def download_file(url, filepath, log_widget):
    try:
        response = requests.get(url)
        if response.status_code == 200:
            with open(filepath, "wb") as f:
                f.write(response.content)
            log_widget.insert(END, f"✅ دانلود شد: {filepath}\n")
        else:
            log_widget.insert(END, f"❌ خطا در دانلود {url}\n")
    except Exception as e:
        log_widget.insert(END, f"❌ خطا در اتصال به {url} → {e}\n")
    log_widget.see(END)

def write_link_to_txt(folder_path, folder_name, link):
    file_path = os.path.join(folder_path, f"{folder_name}.txt")
    with open(file_path, "w", encoding="utf-8") as f:
        f.write(link)

def scrape(month, log_widget, progress_bar, progress_text):
    links = read_links_from_file()
    total_links = len(links)
    if total_links == 0:
        log_widget.insert(END, "❌ هیچ لینکی داخل فایل نیست!\n")
        log_widget.see(END)
        return

    MONTH = month.get()
    if not MONTH.isdigit():
        log_widget.insert(END, "❌ لطفاً عدد ماه را درست وارد کن (مثلاً 5)\n")
        log_widget.see(END)
        return

    log_widget.delete(1.0, END)
    log_widget.insert(END, f"✅ شروع پردازش {total_links} لینک برای ماه {MONTH}...\n")
    log_widget.see(END)

    with sync_playwright() as p:
        context = p.chromium.launch_persistent_context(user_data_dir="envato_profile", headless=False)
        page = context.new_page()

        for i, link in enumerate(links):
            try:
                page.goto(link)
                page.wait_for_load_state("networkidle")

                title = page.locator("h1").inner_text().strip()
                folder_name = sanitize_filename(title)
                full_folder_path = os.path.join(BASE_DOWNLOAD_DIR, folder_name)
                os.makedirs(full_folder_path, exist_ok=True)
                write_link_to_txt(full_folder_path, folder_name, link)

                final_links = {}

                try:
                    image_url = page.locator("meta[property='og:image']").get_attribute("content")
                    if image_url:
                        image_path = os.path.join(full_folder_path, f"{folder_name}.jpg")
                        download_file(image_url, image_path, log_widget)
                        ftp_path = f"/www/image/{YEAR}/{MONTH}/{folder_name}.jpg"
                        ftp_upload(image_path, ftp_path, log_widget)
                        final_links["Image"] = ftp_path.replace("/www", "https://s1.editora.ir")
                except:
                    log_widget.insert(END, "❌ تصویر شاخص یافت نشد\n")

                try:
                    preview_url = page.locator("[data-testid='button-download-preview']").get_attribute("href")
                    if preview_url:
                        video_path = os.path.join(full_folder_path, f"{folder_name}.mp4")
                        download_file(preview_url, video_path, log_widget)
                        ftp_path = f"/www/video/{YEAR}/{MONTH}/{folder_name}.mp4"
                        ftp_upload(video_path, ftp_path, log_widget)
                        final_links["Video"] = ftp_path.replace("/www", "https://s1.editora.ir")
                except:
                    log_widget.insert(END, "❌ لینک ویدیوی دمو یافت نشد\n")

                try:
                    page.click("button:has-text('Download')")
                    page.wait_for_selector("button[data-testid='download-without-license-button']", timeout=5000)
                    with page.expect_download() as download_info:
                        page.click("button[data-testid='download-without-license-button']")
                    download = download_info.value
                    zip_path = os.path.join(full_folder_path, f"{folder_name}.zip")
                    download.save_as(zip_path)
                    log_widget.insert(END, f"✅ فایل ZIP ذخیره شد: {zip_path}\n")
                    ftp_path = f"/www/downloads/vip/{YEAR}/{MONTH}/{folder_name}.zip"
                    ftp_upload(zip_path, ftp_path, log_widget)
                    final_links["ZIP"] = ftp_path.replace("/www", "https://s1.editora.ir")
                except Exception as e:
                    log_widget.insert(END, f"❌ خطا در دانلود فایل ZIP: {e}\n")

                uploaded_products.append({"title": folder_name, "links": final_links})

                # 👇 بعد از پایان آپلودها، اطلاعات به وردپرس ارسال شود
                upload_to_wordpress(folder_name, MONTH)

            except Exception as e:
                log_widget.insert(END, f"❌ خطا در پردازش لینک: {link} → {e}\n")

            percent = int(((i+1) / total_links) * 100)
            progress_bar['value'] = percent
            progress_text.set(f"{percent}%")
            log_widget.update_idletasks()

        context.close()
        log_widget.insert(END, "🎉 همه لینک‌ها با موفقیت پردازش شدند.\n")
        log_widget.see(END)
        show_final_links()

def show_final_links():
    win = Tk()
    win.title("لینک‌های نهایی آپلود شده")
    win.geometry("900x600")

    canvas = Canvas(win)
    scrollbar = Scrollbar(win, orient="vertical", command=canvas.yview)
    scrollable_frame = Frame(canvas)
    scrollable_frame.bind("<Configure>", lambda e: canvas.configure(scrollregion=canvas.bbox("all")))
    canvas.create_window((0, 0), window=scrollable_frame, anchor="nw")
    canvas.configure(yscrollcommand=scrollbar.set)

    canvas.pack(side="left", fill="both", expand=True)
    scrollbar.pack(side="right", fill="y")

    def copy_to_clipboard(text):
        win.clipboard_clear()
        win.clipboard_append(text)
        win.update()

    for product in uploaded_products:
        box = LabelFrame(scrollable_frame, text=f"📁 {product['title']}", padx=10, pady=10)
        box.pack(padx=10, pady=10, fill="x", expand=True)
        for label, url in product["links"].items():
            row = Frame(box)
            row.pack(fill="x", pady=2)
            Label(row, text=f"{label}:", width=10, anchor="w").pack(side="left")
            entry = Entry(row, width=80)
            entry.insert(0, url)
            entry.config(state="readonly")
            entry.pack(side="left", padx=5)
            Button(row, text="📋 کپی", command=lambda u=url: copy_to_clipboard(u)).pack(side="left")

    win.mainloop()

def start_gui():
    root = Tk()
    root.title("دانلودر و آپلودر Envato با نمایش لینک")
    root.geometry("850x600")

    Label(root, text="ماه (مثلاً 5):").pack(pady=5)
    month_input = Entry(root)
    month_input.pack(pady=5)

    progress_text = StringVar()
    progress_text.set("0%")

    progress_bar = Progressbar(root, orient='horizontal', length=500, mode='determinate')
    progress_bar.pack(pady=5)
    Label(root, textvariable=progress_text).pack(pady=2)

    start_btn = Button(root, text="شروع دانلود و آپلود", bg="#28a745", fg="white",
                       command=lambda: threading.Thread(
                           target=scrape,
                           args=(month_input, log_text, progress_bar, progress_text),
                           daemon=True
                       ).start())
    start_btn.pack(pady=10)

    log_frame = Frame(root)
    log_scroll = Scrollbar(log_frame)
    log_scroll.pack(side=RIGHT, fill=Y)

    global log_text
    log_text = Text(log_frame, height=20, width=100, yscrollcommand=log_scroll.set)
    log_text.pack(side=LEFT, fill=BOTH)
    log_scroll.config(command=log_text.yview)
    log_frame.pack(pady=10)

    root.mainloop()

if __name__ == "__main__":
    start_gui()
